#########################################################################################
# Alessandro Bugliarelli 2023
# JLNT TCAD modeling
# PMOS INVERTER STATIC OUTPUT CHARACTERISTICS - 20 NM DEVICE
# RESISTIVE LOAD WITH PULLDOWN TRANSISTOR - VD = -1.1 V
# LOGIC 0 = -1.1 V  LOGIC 1 = 0 V
#########################################################################################
Device PMOS {
	File {
		Grid		= "pmos_inverter_msh.tdr"
		Plot		= "pmos_inverter"
		Current		= "pmos_inverter"
		Parameter	= "pmos_inverter.par"
	}

	Electrode {
		{ name="Source"    Voltage=0.0 }
		{ name="Drain"     Voltage=0.0 DistResist = SchottkyResist }
		{ name="Gate"      Voltage=0.0 }
	}

	Physics{
		Fermi
		Mobility( DopingDep HighFieldSaturation ( ParameterSetName = "myHighField" ) Enormal )
		EffectiveIntrinsicDensity( Bennett )
		Recombination(
		SRH( DopingDep )
#		Band2Band (
#			Model = Hurkx
#			DensityCorrection = Local 
#			ParameterSetName = ("myBTBT") )
		)
		eQuantumPotential
		hQuantumPotential
	}

	Physics(MaterialInterface = "Silicon/SiO2"){
		Traps(
			Acceptor Level EnergyMid=-0.3 fromMidBandGap 
			Conc=4.0e11 eXsection=1e-14  hXsection=1e-14
		)
	}
}

Math{
	Extrapolate
	RelErrControl
#	Digits=4
# 	Notdamped=50
#  	Iterations=24
#  	Transient=BE
#  	Method=Blocked
#  	SubMethod=ParDiSo
}

Plot{
	NonLocal
	eDensity hDensity
	eCurrent hCurrent
	TotalCurrent/Vector eCurrent/Vector hCurrent/Vector
	eMobility hMobility
	eVelocity hVelocity
	eEnormal hEnormal
	ElectricField/Vector Potential SpaceCharge
	eQuasiFermi hQuasiFermi
	Potential Doping SpaceCharge
	SRH Auger 
	AvalancheGeneration
	DonorConcentration AcceptorConcentration
	Doping
	eGradQuasiFermi/Vector hGradQuasiFermi/Vector
	eEparallel hEparalllel
	BandGap 
	BandGapNarrowing
	Affinity
	ConductionBand ValenceBand
	eQuantumPotential 
	hQuantumPotential
}

File {
	Output = "@log@"
}

System {
	Vsource_pset vdd (dd 0) { dc = 0.0 }
	Vsource_pset vin (in 0) { dc = 0.0 }

	PMOS pulldown ( "Drain" = out "Gate" = in "Source" = 0 )
	Resistor_pset rload ( dd out ){ resistance = 100e6 }
	Plot "n@node@_sys_des.plt" (time() v(in) v(out) i(pulldown,out) )
}

Solve {  
	NewCurrentPrefix="init"
	Coupled(Iterations=100){ Poisson }
	Coupled{ Poisson Electron Hole Contact Circuit }

	Quasistationary( 
	InitialStep=0.05 MaxStep=0.05 MinStep=0.0001
	Goal{ Parameter=vdd.dc Voltage= -1.1 } 
	){ Coupled{ pulldown.poisson pulldown.electron pulldown.hole pulldown.contact circuit }
	}

	Quasistationary( 
	InitialStep=0.05 MaxStep=0.05 MinStep=0.0001
	Goal{ Parameter=vin.dc Voltage= -1.1 } 
	){ Coupled{ pulldown.poisson pulldown.electron pulldown.hole pulldown.contact circuit }
	}

	NewCurrentPrefix=""
	Quasistationary( 
	InitialStep=0.05 MaxStep=0.05 MinStep=0.0001
	Goal{ Parameter=vin.dc Voltage= 0.5 } 
	){ Coupled{ pulldown.poisson pulldown.electron pulldown.hole pulldown.contact circuit }
	}
}

